# Deployment Guide for serpforge.compalgolabs.com

To ensure all links (Purchase, Download, Upgrade) work correctly, please structure your hosting files exactly as follows.

## 1. What to Upload
You need to upload files to the **Root Directory** (public_html) of your hosting.

1.  **Extract** the `website` folder on your computer.
2.  Upload all **files inside `website`** (index.html, checkout.html, etc.) directly to `public_html`.
3.  Create a folder named **`downloads`** inside `public_html`.
4.  Upload **`serpforge-seo.zip`** AND **`serpforge-seo-free.zip`** inside the `downloads` folder.

## 2. Final Folder Structure
After uploading, your File Manager should look like this:

```text
/public_html/
├── index.html                  <-- Homepage (at root)
├── checkout.html               <-- Purchase Page
├── css/
├── js/
├── api/
│   └── purchase.php
└── downloads/                  <-- (Folder)
    ├── serpforge-seo.zip       <-- The Pro Plugin
    └── serpforge-seo-free.zip  <-- The Free Plugin
```

## 3. Why this structure?
This matches the URLs we configured:
- **Homepage:** `https://serpforge.compalgolabs.com/`
- **Upgrade Banner:** `https://serpforge.compalgolabs.com/checkout.html`
- **Download Link:** `https://serpforge.compalgolabs.com/downloads/serpforge-seo.zip`

## 4. SMTP Configuration
Because `purchase.php` is inside `website/api/`, it will run on your live server.
- Ensure your hosting allows outbound SMTP connections to Gmail (Port 587).
- If emails fail, check your hosting logs or "PHP Error Logs".

## 5. Testing
1.  Visit `https://serpforge.compalgolabs.com/website/` -> Should show Homepage.
2.  Visit `https://serpforge.compalgolabs.com/serpforge-seo.zip` -> Should download the zip.
3.  Go to `checkout.html` and make a test purchase.

**Done! 🚀**
