/**
 * SERPforge Admin JS
 */

document.addEventListener('DOMContentLoaded', function () {
    const appContainer = document.getElementById('serpforge-admin-app');

    if (appContainer) {
        // Simple Render Logic (simulating a React-like structure for the demo)
        // In a real build step, we would compile JSX. Here we use Vanilla JS/jQuery for compatibility without build tools.

        // Initialize Active Modules
        const activeModules = (typeof serpforgeData !== 'undefined' && serpforgeData.activeModules) 
            ? serpforgeData.activeModules 
            : ['image-seo', 'sitemap', 'link-counter']; // Default Fallback

        // Global Toggle Function
        window.toggleModule = function(moduleId) {
            if (typeof jQuery === 'undefined') return;
            
            jQuery.post(serpforgeData.ajaxUrl, {
                action: 'serpforge_toggle_module',
                module: moduleId,
                nonce: serpforgeData.nonce
            }, function(res) {
                 if(res.success) {
                     // potentially show a toast or sync state
                     console.log('Module toggled:', moduleId, res.data.active);
                 } else {
                     alert('Failed to toggle module.');
                     // Revert switch if needed
                 }
            });
        };

        let dashboardHTML = `
            <div class="serpforge-dashboard">
                <div class="serpforge-header">
                    <h1>Module Manager</h1>
                    <div class="actions">
                        <button class="button button-secondary" onclick="window.location.reload()">Refresh Modules</button>
                    </div>
                </div>

                <!-- License Status (Top Bar) -->
                <div id="serpforge-license-bar" style="background:#fff; padding:15px; margin:0 20px 20px; border:1px solid #e5e5e5; border-radius:4px; display:flex; justify-content:space-between; align-items:center;">
                     <div id="serpforge-license-area-inline">
                        <strong>License:</strong> 
                        <span id="lb-status">Checking...</span>
                        <input type="text" id="serpforge-license-key-inline" placeholder="Enter PRO Key" style="display:none; margin-left:10px;">
                        <button id="serpforge-activate-btn-inline" class="button button-small" style="display:none;">Activate</button>
                     </div>
                     <span id="lb-msg"></span>
                </div>
                
                <div class="serpforge-module-grid">
                    ${renderModuleCard('Image SEO', 'image-seo', 'dashicons-format-image', 'Auto-add Alt (Free) & Title (Pro) tags.', false)}
                    ${renderModuleCard('Sitemap', 'sitemap', 'dashicons-networking', 'Advanced XML Sitemaps.', false)}
                    ${renderModuleCard('Link Counter', 'link-counter', 'dashicons-admin-links', 'Count internal/external links.', false)}
                    
                    <!-- Pro Modules -->
                    ${renderModuleCard('WooCommerce', 'woocommerce', 'dashicons-cart', 'Optimize Product pages with Rich Snippets.', true)}
                    ${renderModuleCard('Local SEO', 'local-seo', 'dashicons-location', 'Dominate local search results.', true)}
                    ${renderModuleCard('404 Monitor', 'monitor', 'dashicons-warning', 'Record and analyze 404 errors.', true)}
                    ${renderModuleCard('Redirections', 'redirects', 'dashicons-randomize', 'Manage 301 and 302 redirects.', true)}
                    ${renderModuleCard('Schema', 'schema', 'dashicons-layout', 'Add proper Structured Data.', false)} 
                    ${renderModuleCard('News Sitemap', 'news-sitemap', 'dashicons-media-document', 'Google News compliant sitemap.', true)}
                    ${renderModuleCard('Podcast', 'podcast', 'dashicons-microphone', 'Optimized RSS feeds for Podcasters.', true)}
                </div>
            </div>
        `;

        function renderModuleCard(title, id, icon, desc, isPro) {
            // Check if active in the localized data
            const isActive = activeModules.includes(id);
            const checked = isActive ? 'checked' : '';

            // Determine Settings Link
            let settingsBtn = `<a href="#" class="button button-small" onclick="alert('Settings for ${title} coming soon!')">Settings</a>`;

            if (id === 'redirects') {
                settingsBtn = `<a href="admin.php?page=serpforge-redirects" class="button button-small">Settings</a>`;
            } else if (id === 'image-seo') {
                settingsBtn = `<a href="admin.php?page=serpforge-image-seo" class="button button-small">Settings</a>`;
            } else if (id === 'sitemap') {
                settingsBtn = `<a href="admin.php?page=serpforge-sitemap" class="button button-small">Settings</a>`;
            } else if (id === 'woocommerce') {
                settingsBtn = `<a href="admin.php?page=serpforge-woocommerce" class="button button-small">Settings</a>`;
            } else if (id === 'local-seo') {
                settingsBtn = `<a href="admin.php?page=serpforge-local-seo" class="button button-small">Settings</a>`;
            } else if (id === 'monitor') {
                settingsBtn = `<a href="admin.php?page=serpforge-404-monitor" class="button button-small">Settings</a>`;
            } else if (id === 'schema') {
                settingsBtn = `<a href="admin.php?page=serpforge-schema" class="button button-small">Settings</a>`;
            } else if (id === 'link-counter') {
                settingsBtn = `<a href="admin.php?page=serpforge-link-counter" class="button button-small">Settings</a>`;
            } else if (id === 'news-sitemap') {
                settingsBtn = `<a href="admin.php?page=serpforge-news-sitemap" class="button button-small">Settings</a>`;
            } else if (id === 'podcast') {
                settingsBtn = `<a href="admin.php?page=serpforge-podcast" class="button button-small">Settings</a>`;
            } else {
                settingsBtn = `<a href="#" class="button button-small" onclick="alert('Settings for ${title} coming soon!')">Settings</a>`;
            }
            // RankMath Style Card
            return `
            <div class="serpforge-module-card" id="card-${id}">
                <div class="module-icon">
                    <span class="dashicons ${icon}"></span>
                </div>
                <div class="module-content">
                    <h3>${title}</h3>
                    <p>${desc}</p>
                </div>
                <div class="module-actions">
                    ${settingsBtn}
                    <label class="serpforge-switch">
                        <input type="checkbox" ${checked} onchange="toggleModule('${id}')">
                        <span class="slider round"></span>
                    </label>
                </div>
            </div>
            `;
        }

        appContainer.innerHTML = dashboardHTML;

        // Fetch Dashboard Data (License Check only)
        if (typeof jQuery !== 'undefined' && typeof serpforgeData !== 'undefined') {
            jQuery.post(serpforgeData.ajaxUrl, {
                action: 'serpforge_get_dashboard_data',
                nonce: serpforgeData.nonce
            }, function (res) {
                if (res.success) {
                    const data = res.data;

                    if (data.license_status === 'valid') {
                        document.getElementById('lb-status').innerHTML = '<span style="color:green; font-weight:bold;">Active</span>';
                        document.getElementById('lb-msg').innerText = 'Pro Features Unlocked';
                    } else {
                        document.getElementById('lb-status').innerHTML = '<span style="color:red; font-weight:bold;">Inactive</span>';
                        document.getElementById('serpforge-license-key-inline').style.display = 'inline-block';
                        document.getElementById('serpforge-activate-btn-inline').style.display = 'inline-block';
                    }
                }
            });

            // Re-bind Inline Activation
            const adminBtn = document.getElementById('serpforge-activate-btn-inline');
            if (adminBtn) {
                adminBtn.addEventListener('click', function () {
                    const key = document.getElementById('serpforge-license-key-inline').value;
                    jQuery.post(serpforgeData.ajaxUrl, {
                        action: 'serpforge_activate_license',
                        license_key: key,
                        serpforge_license_nonce: serpforgeData.nonce
                    }, function (response) {
                        if (response.success) {
                            alert('Activated! Reloading...');
                            window.location.reload();
                        } else {
                            alert(response.data.message);
                        }
                    });
                });
            }
        }


        // License Activation Logic
        const activateBtn = document.getElementById('serpforge-activate-btn');
        if (activateBtn) {
            activateBtn.addEventListener('click', function () {
                const key = document.getElementById('serpforge-license-key').value;
                const msg = document.getElementById('serpforge-license-msg');

                msg.innerHTML = 'Activating...';

                jQuery.post(serpforgeData.ajaxUrl, {
                    action: 'serpforge_activate_license',
                    license_key: key,
                    serpforge_license_nonce: serpforgeData.nonce
                }, function (response) {
                    if (response.success) {
                        msg.innerHTML = '<span style="color:green;">' + response.data.message + ' Reloading...</span>';
                        setTimeout(function () {
                            window.location.reload();
                        }, 1500);
                    } else {
                        msg.innerHTML = '<span style="color:red;">' + response.data.message + '</span>';
                    }
                });
            });
        }
    }
});
