jQuery(document).ready(function ($) {

    // Tab Switching
    $('.serpforge-tab').on('click', function (e) {
        e.preventDefault();
        $('.serpforge-tab').removeClass('active');
        $(this).addClass('active');
        $('.serpforge-tab-content').removeClass('active');
        $('#tab-' + $(this).data('tab')).addClass('active');
    });

    // Toggle Snippet Editor
    $('#edit-snippet-btn').on('click', function () {
        $('.snippet-editor').toggleClass('hidden');
    });

    // Update Live Preview (Simple binding)
    $('#serpforge_seo_title').on('input', function () {
        $('.preview-title').text($(this).val());
        $('#title-char-count').text($(this).val().length);
    });

    $('#serpforge_seo_description').on('input', function () {
        $('.preview-desc').text($(this).val());
        $('#desc-char-count').text($(this).val().length);
    });

    // Run Analysis (Debounced)
    let typingTimer;
    $('#serpforge_focus_keyword, #content, #title').on('input', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(runAnalysis, 1000);
    });

    // Trigger on load
    setTimeout(runAnalysis, 2000);

    function runAnalysis() {
        // Try to get content from TinyMCE or Block Editor
        let content = '';
        if (typeof wp !== 'undefined') {
            if (wp.data && wp.data.select && wp.data.select('core/editor')) {
                // Gutenberg
                content = wp.data.select('core/editor').getEditedPostContent();
            } else if (wp.editor && wp.editor.getContent) {
                // TinyMCE
                content = wp.editor.getContent('content');
            }
        }

        // Fallback
        if (!content) content = $('#content').val();

        let title = '';
        if (typeof wp !== 'undefined' && wp.data && wp.data.select('core/editor')) {
            title = wp.data.select('core/editor').getEditedPostAttribute('title');
        } else {
            title = $('#title').val();
        }

        const keyword = $('#serpforge_focus_keyword').val();

        if (!keyword) {
            $('#serpforge-analysis-results').html('<p style="color:orange;">Please enter a focus keyword.</p>');
            $('#serpforge-score-val').text('--');
            return;
        }

        $('#serpforge-analysis-results').html('<p>Analyzing...</p>');

        $.post(serpforgeData.ajaxUrl, {
            action: 'serpforge_analyze_content',
            content: content,
            keyword: keyword,
            title: title || $('#serpforge_seo_title').val(),
            nonce: serpforgeData.nonce
        }, function (res) {
            if (res.success) {
                let html = '<ul>';
                $.each(res.data.checks, function (k, v) {
                    let icon = v.status === 'good' ? '✔' : '⚠';
                    let color = v.status === 'good' ? 'green' : (v.status === 'critical' ? 'red' : 'orange');
                    html += '<li style="color:' + color + '; margin-bottom:5px;">' + icon + ' ' + v.msg + '</li>';
                });
                html += '</ul>';

                $('#serpforge-analysis-results').html(html);

                // Animate Dial
                let score = res.data.score;
                $('#serpforge-score-val').text(score);
                $('#serpforge-score-dial').css('border-color', score > 80 ? '#00b300' : (score > 50 ? 'orange' : 'red'));
            }
        });
    }

    // AI Generation
    $('#serpforge-ai-generate').on('click', function (e) {
        e.preventDefault();
        let btn = $(this);
        let spinner = $('#serpforge-ai-spinner');

        // Get content title
        let title = '';
        if (typeof wp !== 'undefined' && wp.data && wp.data.select('core/editor')) {
            title = wp.data.select('core/editor').getEditedPostAttribute('title');
        } else {
            title = $('#title').val();
        }

        if (!title) {
            alert('Please add a post title first.');
            return;
        }

        btn.prop('disabled', true);
        spinner.addClass('is-active');

        $.post(serpforgeData.ajaxUrl, {
            action: 'serpforge_get_ai_suggestions',
            title: title,
            nonce: serpforgeData.nonce
        }, function (res) {
            btn.prop('disabled', false);
            spinner.removeClass('is-active');

            if (res.success) {
                // Populate fields
                let suggestedTitle = res.data.titles[0]; // Take first for now
                let suggestedDesc = res.data.meta_description;

                $('#serpforge_seo_title').val(suggestedTitle).trigger('input');
                $('#serpforge_seo_description').val(suggestedDesc).trigger('input');

                // Show success
                let originalText = btn.text();
                btn.text('✨ Generated!');
                setTimeout(() => btn.text(originalText), 2000);
            } else {
                alert('AI Error: ' + res.data);
            }
        });
    });

});
