<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" 
                xmlns:html="http://www.w3.org/TR/REC-html40"
                xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>XML Sitemap - SERPforge SEO</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				<style type="text/css">
					body {
						font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
						color: #333;
						margin: 0;
						padding: 40px;
						background: #f1f1f1;
					}
					#content {
						background: #fff;
						padding: 40px;
						border-radius: 5px;
						box-shadow: 0 2px 5px rgba(0,0,0,0.05);
						max-width: 900px;
						margin: 0 auto;
					}
					h1 {
						color: #2271b1;
						font-size: 24px;
						margin-bottom: 20px;
						border-bottom: 1px solid #eee;
						padding-bottom: 20px;
					}
					p.explainer {
						font-size: 14px;
						color: #666;
						margin-bottom: 30px;
					}
					table {
						width: 100%;
						border-collapse: collapse;
						font-size: 14px;
					}
					th, td {
						text-align: left;
						padding: 12px;
						border-bottom: 1px solid #eee;
					}
					th {
						color: #666;
						font-weight: 600;
						font-size: 12px;
						text-transform: uppercase;
					}
					tr:hover td {
						background: #f9f9f9;
					}
					a {
						color: #2271b1;
						text-decoration: none;
					}
					a:hover {
						text-decoration: underline;
					}
				</style>
			</head>
			<body>
				<div id="content">
					<h1>XML Sitemap</h1>
					<p class="explainer">
						Generated by <strong>SERPforge SEO</strong> - The professional SEO plugin for WordPress.
						<br/>
						This is an XML Sitemap, meant for search engines like Google.
					</p>
					
					<xsl:choose>
						<xsl:when test="//*[local-name()='sitemapindex']">
							<table>
								<thead>
									<tr>
										<th>Sitemap</th>
										<th>Last Modified</th>
									</tr>
								</thead>
								<tbody>
									<xsl:for-each select="sitemap:sitemapindex/sitemap:sitemap">
										<tr>
											<td>
												<a href="{sitemap:loc}"><xsl:value-of select="sitemap:loc"/></a>
											</td>
											<td>
												<xsl:value-of select="sitemap:lastmod"/>
											</td>
										</tr>
									</xsl:for-each>
								</tbody>
							</table>
						</xsl:when>
						<xsl:otherwise>
							<table>
								<thead>
									<tr>
										<th>URL</th>
										<th>Last Modified</th>
										<th>Change Frequency</th>
										<th>Priority</th>
									</tr>
								</thead>
								<tbody>
									<xsl:for-each select="sitemap:urlset/sitemap:url">
										<tr>
											<td>
												<a href="{sitemap:loc}"><xsl:value-of select="sitemap:loc"/></a>
											</td>
											<td>
												<xsl:value-of select="sitemap:lastmod"/>
											</td>
											<td>
												<xsl:value-of select="sitemap:changefreq"/>
											</td>
											<td>
												<xsl:value-of select="sitemap:priority"/>
											</td>
										</tr>
									</xsl:for-each>
								</tbody>
							</table>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
