<?php
namespace SerpForge\Admin;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Handles data fetching for the Admin Dashboard.
 */
class DashboardData
{

    public function __construct()
    {
        add_action('wp_ajax_serpforge_get_dashboard_data', [$this, 'get_stats']);
    }

    /**
     * AJAX Handler for dashboard stats.
     */
    public function get_stats()
    {
        // check_ajax_referer...

        // 1. Calculate Site Health (Mock logic based on post counts for now)
        $published_posts = wp_count_posts()->publish;
        $pages = wp_count_posts('page')->publish;
        $total_content = $published_posts + $pages;

        // In a real app, query all meta for '_serpforge_seo_score' and average them.
        // For MVP, we simply randomize/mock or return a placeholder if no data exists.
        $health_score = ($total_content > 0) ? 88 : 0;

        // 2. Fetch Recent Posts
        $recent_posts = get_posts([
            'numberposts' => 5,
            'post_status' => 'publish',
        ]);

        $posts_data = [];
        foreach ($recent_posts as $p) {
            // Get score or default to 'N/A'
            // We haven't saved a score yet in logic, let's assume valid state if meta exists
            $focus_kw = get_post_meta($p->ID, '_serpforge_focus_keyword', true);
            $has_seo = !empty($focus_kw);

            $posts_data[] = [
                'title' => get_the_title($p),
                'edit_url' => get_edit_post_link($p->ID, 'raw'),
                'score' => $has_seo ? rand(70, 95) : 'N/A', // Mock score for demo until we save analysis
                'status' => $has_seo ? 'Optimized' : 'Needs Focus KW',
            ];
        }

        wp_send_json_success([
            'health_score' => $health_score,
            'total_content' => $total_content,
            'recent_posts' => $posts_data,
            'license_status' => get_option('serpforge_license_status'),
            'license_key' => get_option('serpforge_license_key'),
        ]);
    }
}
