<?php
namespace SerpForge\Admin;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Handles Module Settings Pages.
 */
class ModuleSettingsController
{
    public function render_woocommerce_settings()
    {
        if (isset($_POST['save_woo_settings']) && check_admin_referer('serpforge_woo_settings')) {
            update_option('serpforge_woo_remove_generator', isset($_POST['remove_generator']) ? '1' : '0');
            update_option('serpforge_woo_remove_schema', isset($_POST['remove_schema']) ? '1' : '0');
            update_option('serpforge_woo_product_title', sanitize_text_field($_POST['product_title_format']));
            // Trigger flush or simple success
            echo '<div class="notice notice-success is-dismissible"><p>WooCommerce settings saved.</p></div>';
        }

        $remove_gen = get_option('serpforge_woo_remove_generator', '0');
        $remove_schema = get_option('serpforge_woo_remove_schema', '0');
        $title_format = get_option('serpforge_woo_product_title', '%title% %sep% %sitename%');
        ?>
        <div class="wrap">
            <h1>WooCommerce SEO Settings</h1>
            <form method="post" action="">
                <?php wp_nonce_field('serpforge_woo_settings'); ?>
                <div class="card" style="max-width: 800px; padding: 20px;">
                    <table class="form-table">
                        <tr>
                            <th scope="row">Clean Up</th>
                            <td>
                                <label>
                                    <input type="checkbox" name="remove_generator" value="1" <?php checked($remove_gen, '1'); ?>>
                                    Remove WooCommerce Generator Tag
                                </label><br>
                                <label>
                                    <input type="checkbox" name="remove_schema" value="1" <?php checked($remove_schema, '1'); ?>>
                                    Remove default WooCommerce Schema
                                </label>
                                <p class="description">Useful if you want to use SERPforge's schema instead.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Product Title Format</th>
                            <td>
                                <input type="text" name="product_title_format" value="<?php echo esc_attr($title_format); ?>" class="regular-text">
                                <p class="description">Variables: %title%, %sep%, %sitename%, %price%, %sku%</p>
                            </td>
                        </tr>
                    </table>
                </div>
                <p><input type="submit" name="save_woo_settings" class="button button-primary" value="Save Settings"></p>
            </form>
        </div>
        <?php
    }

    public function render_local_seo_settings()
    {
        if (isset($_POST['save_local_seo']) && check_admin_referer('serpforge_local_seo')) {
            update_option('serpforge_local_type', sanitize_text_field($_POST['business_type']));
            update_option('serpforge_local_name', sanitize_text_field($_POST['business_name']));
            
            // Address
            update_option('serpforge_local_street', sanitize_text_field($_POST['business_street']));
            update_option('serpforge_local_city', sanitize_text_field($_POST['business_city']));
            update_option('serpforge_local_state', sanitize_text_field($_POST['business_state']));
            update_option('serpforge_local_zip', sanitize_text_field($_POST['business_zip']));
            update_option('serpforge_local_country', sanitize_text_field($_POST['business_country']));

            // Geo
            update_option('serpforge_local_lat', sanitize_text_field($_POST['business_lat']));
            update_option('serpforge_local_lng', sanitize_text_field($_POST['business_lng']));

            update_option('serpforge_local_phone', sanitize_text_field($_POST['business_phone']));
            update_option('serpforge_local_opening_hours', sanitize_textarea_field($_POST['opening_hours']));
            echo '<div class="notice notice-success is-dismissible"><p>Local SEO settings saved.</p></div>';
        }

        $type = get_option('serpforge_local_type', 'LocalBusiness');
        $name = get_option('serpforge_local_name', get_bloginfo('name'));
        
        $street = get_option('serpforge_local_street', '');
        $city = get_option('serpforge_local_city', '');
        $state = get_option('serpforge_local_state', '');
        $zip = get_option('serpforge_local_zip', '');
        $country = get_option('serpforge_local_country', '');

        $lat = get_option('serpforge_local_lat', '');
        $lng = get_option('serpforge_local_lng', '');

        $phone = get_option('serpforge_local_phone', '');
        $hours = get_option('serpforge_local_opening_hours', 'Mo-Fr 09:00-17:00');
        ?>
        <div class="wrap">
            <h1>Local SEO Settings</h1>
            
            <form method="post" action="">
                <?php wp_nonce_field('serpforge_local_seo'); ?>
                
                <div style="display: flex; gap: 20px; align-items: flex-start;">
                    
                    <!-- Left Column: Settings -->
                    <div style="flex: 2; min-width: 400px;">
                        
                        <div class="card" style="padding: 20px;">
                            <h3>Business Identity</h3>
                            <table class="form-table">
                                <tr>
                                    <th scope="row">Business Type</th>
                                    <td>
                                        <select name="business_type" id="sf_type">
                                            <?php 
                                            $types = ['LocalBusiness', 'Organization', 'Restaurant', 'Dentist', 'LegalService', 'MedicalBusiness', 'Store', 'RealEstateAgent', 'TravelAgency'];
                                            foreach ($types as $t) {
                                                echo '<option value="' . esc_attr($t) . '" ' . selected($type, $t, false) . '>' . esc_html($t) . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row">Business Name</th>
                                    <td><input type="text" name="business_name" id="sf_name" value="<?php echo esc_attr($name); ?>" class="regular-text"></td>
                                </tr>
                            </table>
                        </div>

                        <div class="card" style="padding: 20px; margin-top: 20px;">
                            <h3>Location & Address</h3>
                            <table class="form-table">
                                <tr>
                                    <th scope="row">Street Address</th>
                                    <td><input type="text" name="business_street" id="sf_street" value="<?php echo esc_attr($street); ?>" class="large-text"></td>
                                </tr>
                                <tr>
                                    <th scope="row">City</th>
                                    <td><input type="text" name="business_city" id="sf_city" value="<?php echo esc_attr($city); ?>" class="regular-text"></td>
                                </tr>
                                <tr>
                                    <th scope="row">State / Province</th>
                                    <td><input type="text" name="business_state" id="sf_state" value="<?php echo esc_attr($state); ?>" class="regular-text"></td>
                                </tr>
                                <tr>
                                    <th scope="row">Zip / Postal Code</th>
                                    <td><input type="text" name="business_zip" id="sf_zip" value="<?php echo esc_attr($zip); ?>" class="small-text"></td>
                                </tr>
                                <tr>
                                    <th scope="row">Country</th>
                                    <td><input type="text" name="business_country" id="sf_country" value="<?php echo esc_attr($country); ?>" class="small-text" placeholder="US"></td>
                                </tr>
                                <tr>
                                    <th scope="row">Geo Coordinates</th>
                                    <td>
                                        <input type="text" name="business_lat" value="<?php echo esc_attr($lat); ?>" placeholder="Lat" class="regular-text" style="width: 100px;">
                                        <input type="text" name="business_lng" value="<?php echo esc_attr($lng); ?>" placeholder="Lng" class="regular-text" style="width: 100px;">
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="card" style="padding: 20px; margin-top: 20px;">
                            <h3>Contact & Hours</h3>
                             <table class="form-table">
                                <tr>
                                    <th scope="row">Phone Number</th>
                                    <td><input type="text" name="business_phone" id="sf_phone" value="<?php echo esc_attr($phone); ?>" class="regular-text"></td>
                                </tr>
                                <tr>
                                    <th scope="row">Opening Hours</th>
                                    <td>
                                        <textarea name="opening_hours" id="sf_hours" class="large-text" rows="2"><?php echo esc_textarea($hours); ?></textarea>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <p><input type="submit" name="save_local_seo" class="button button-primary" value="Save Location"></p>

                    </div> 
                    <!-- End Left Col -->

                    <!-- Right Column: Live Preview -->
                    <div style="flex: 1; position: sticky; top: 50px;">
                        <div class="card" style="padding: 20px; border-left: 4px solid #2271b1;">
                            <h3>Live Preview</h3>
                            <p><i>This is how the shortcut <code>[serpforge_local_seo]</code> will look:</i></p>
                            
                            <!-- Preview Box -->
                            <div id="sf-preview-box" style="border: 1px solid #ddd; padding: 20px; border-radius: 8px; background: #fff; box-shadow: 0 2px 5px rgba(0,0,0,0.05);">
                                <h3 id="prev_name" style="margin-top: 0; color: #333; font-size: 1.2em;"><?php echo esc_html($name); ?></h3>
                                <p style="font-size: 0.9em; line-height: 1.5; color: #555;">
                                    <strong>📍 Address:</strong><br>
                                    <span id="prev_street"><?php echo esc_html($street); ?></span><br>
                                    <span id="prev_city"><?php echo esc_html($city); ?></span>, 
                                    <span id="prev_state"><?php echo esc_html($state); ?></span> 
                                    <span id="prev_zip"><?php echo esc_html($zip); ?></span> 
                                    <span id="prev_country"><?php echo esc_html($country); ?></span>
                                </p>
                                
                                <p id="prev_phone_wrap" style="font-size: 0.9em; line-height: 1.5; color: #555;">
                                    <strong>📞 Phone:</strong> <span id="prev_phone"><?php echo esc_html($phone); ?></span>
                                </p>

                                <p id="prev_hours_wrap" style="font-size: 0.9em; line-height: 1.5; color: #555; white-space: pre-line;">
                                    <strong>🕒 Hours:</strong><br><span id="prev_hours"><?php echo esc_html($hours); ?></span>
                                </p>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>

        <script>
        document.addEventListener('DOMContentLoaded', function() {
            const fields = {
                'sf_name': 'prev_name',
                'sf_street': 'prev_street',
                'sf_city': 'prev_city',
                'sf_state': 'prev_state',
                'sf_zip': 'prev_zip',
                'sf_country': 'prev_country',
                'sf_phone': 'prev_phone',
                'sf_hours': 'prev_hours'
            };

            Object.keys(fields).forEach(inputId => {
                const input = document.getElementById(inputId);
                if(input) {
                    input.addEventListener('input', function() {
                        const target = document.getElementById(fields[inputId]);
                        if(target) target.innerText = this.value;
                    });
                }
            });
        });
        </script>
        <?php
    }

    public function render_404_logs()
    {
        // Simple Clear Logic
        if (isset($_POST['clear_404_logs']) && check_admin_referer('serpforge_clear_404')) {
            update_option('serpforge_404_logs', []);
            echo '<div class="notice notice-success is-dismissible"><p>Logs cleared.</p></div>';
        }

        // Fetch logs (Simulated or stored in option for MVP)
        $logs = get_option('serpforge_404_logs', []); 
        ?>
        <div class="wrap">
            <h1 class="wp-heading-inline">404 Error Monitor</h1>
            <form method="post" action="" style="display:inline-block; margin-left: 10px;">
                <?php wp_nonce_field('serpforge_clear_404'); ?>
                <input type="submit" name="clear_404_logs" class="page-title-action" value="Clear All Logs" onclick="return confirm('Are you sure?');">
            </form>
            
            <div class="card" style="margin-top: 20px;">
                <table class="wp-list-table widefat fixed striped table-view-list">
                    <thead>
                        <tr>
                            <th>URL</th>
                            <th>Date</th>
                            <th>IP Address</th>
                            <th>Referer</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($logs)): ?>
                            <tr><td colspan="4">No 404 errors recorded yet. High five! 🙌</td></tr>
                        <?php else: ?>
                            <?php foreach (array_reverse($logs) as $log): ?>
                                <tr>
                                    <td><a href="<?php echo esc_url(home_url($log['uri'])); ?>" target="_blank"><?php echo esc_html($log['uri']); ?></a></td>
                                    <td><?php echo esc_html($log['time']); ?></td>
                                    <td><?php echo esc_html($log['ip']); ?></td>
                                    <td><?php echo esc_html($log['referer'] ?: '-'); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php
    }

    public function render_schema_settings()
    {
        if (isset($_POST['save_schema_settings']) && check_admin_referer('serpforge_schema_global')) {
            update_option('serpforge_schema_entity_type', sanitize_text_field($_POST['entity_type']));
            update_option('serpforge_knowledge_name', sanitize_text_field($_POST['knowledge_name']));
            update_option('serpforge_knowledge_logo', sanitize_url($_POST['knowledge_logo']));
            echo '<div class="notice notice-success is-dismissible"><p>Schema settings saved.</p></div>';
        }

        $type = get_option('serpforge_schema_entity_type', 'Organization');
        $name = get_option('serpforge_knowledge_name', get_bloginfo('name'));
        $logo = get_option('serpforge_knowledge_logo', get_site_icon_url(512));
        ?>
        <div class="wrap">
            <h1>Schema Settings (Knowledge Graph)</h1>
            <form method="post" action="">
                <?php wp_nonce_field('serpforge_schema_global'); ?>

                <div class="card" style="max-width: 800px; padding: 20px;">
                    <table class="form-table">
                        <tr>
                            <th scope="row">Person or Organization?</th>
                            <td>
                                <select name="entity_type">
                                    <option value="Organization" <?php selected($type, 'Organization'); ?>>Organization</option>
                                    <option value="Person" <?php selected($type, 'Person'); ?>>Person</option>
                                </select>
                                <p class="description">This data is shown as the Knowledge Graph in search results.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Website Name</th>
                            <td>
                                <input type="text" name="knowledge_name" value="<?php echo esc_attr($name); ?>"
                                    class="regular-text">
                                <p class="description">The name used for your entity in search results.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Logo / Avatar URL</th>
                            <td>
                                <input type="text" name="knowledge_logo" value="<?php echo esc_url($logo); ?>"
                                    class="regular-text">
                                <p class="description">URL to your Organization Logo or Person's Avatar.</p>
                            </td>
                        </tr>
                    </table>
                </div>

                <p><input type="submit" name="save_schema_settings" class="button button-primary" value="Save Changes"></p>
            </form>
        </div>
        <?php
    }

    public function render_link_counter_settings()
    {
        // Get Stats
        $args = [
            'post_type' => ['post', 'page'],
            'post_status' => 'publish',
            'posts_per_page' => 20,
            'meta_key' => 'serpforge_internal_links',
            'orderby' => 'meta_value_num',
            'order' => 'DESC'
        ];
        $posts = get_posts($args);
        ?>
        <div class="wrap">
            <h1>Link Counter</h1>
            <p>Analyze the internal and external linking structure of your site.</p>

            <div class="card" style="max-width: 800px; padding: 20px; margin-bottom: 20px;">
                <h2>Actions</h2>
                <p>Click the button below to scan all your posts and pages to update the link counts.</p>
                <button id="serpforge-recount-links" class="button button-primary">Update Link Counts</button>
                <span class="spinner" id="serpforge-recount-spinner" style="float:none;"></span>
                <span id="serpforge-recount-msg" style="margin-left: 10px; font-weight: bold;"></span>
            </div>

            <div class="card" style="max-width: 800px; padding: 0; margin-bottom: 20px;">
                <h2 style="padding: 20px 20px 0;">Top Linked Posts (Internal)</h2>
                <table class="wp-list-table widefat fixed striped" style="border:none;">
                    <thead>
                        <tr>
                            <th>Post Title</th>
                            <th style="width: 100px;">Internal</th>
                            <th style="width: 100px;">External</th>
                            <th style="width: 100px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($posts)): ?>
                            <tr><td colspan="4" style="padding: 20px;">No data found. Try updating link counts.</td></tr>
                        <?php else: ?>
                            <?php foreach ($posts as $p): 
                                $int = get_post_meta($p->ID, 'serpforge_internal_links', true) ?: 0;
                                $ext = get_post_meta($p->ID, 'serpforge_external_links', true) ?: 0;
                            ?>
                            <tr>
                                <td><strong><?php echo esc_html($p->post_title); ?></strong></td>
                                <td style="color: green; font-weight: bold;"><?php echo intval($int); ?></td>
                                <td style="color: orange; font-weight: bold;"><?php echo intval($ext); ?></td>
                                <td><a href="<?php echo get_edit_post_link($p->ID); ?>" class="button button-small">Edit</a></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <script type="text/javascript">
            jQuery(document).ready(function($) {
                $('#serpforge-recount-links').click(function() {
                    var btn = $(this);
                    var spinner = $('#serpforge-recount-spinner');
                    var msg = $('#serpforge-recount-msg');

                    btn.prop('disabled', true);
                    spinner.addClass('is-active');
                    msg.text('Scanning posts...');

                    $.post(serpforgeData.ajaxUrl, {
                        action: 'serpforge_recount_links',
                        nonce: serpforgeData.nonce
                    }, function(res) {
                        btn.prop('disabled', false);
                        spinner.removeClass('is-active');
                        if (res.success) {
                            msg.text('Success! ' + res.data.processed + ' posts updated. Refreshing...');
                            setTimeout(function() { location.reload(); }, 1500);
                        } else {
                            msg.css('color', 'red').text('Error: ' + res.data);
                        }
                    });
                });
            });
            </script>
        </div>
        <?php
    }

    public function render_news_sitemap_settings()
    {
        if (isset($_POST['save_news_sitemap']) && check_admin_referer('serpforge_news_sitemap')) {
            update_option('serpforge_news_name', sanitize_text_field($_POST['news_name']));
            
            // Save post types
            $post_types = isset($_POST['news_post_types']) ? array_map('sanitize_text_field', $_POST['news_post_types']) : ['post'];
            update_option('serpforge_news_post_types', $post_types);
            
            echo '<div class="notice notice-success is-dismissible"><p>News Sitemap settings saved.</p></div>';
        }

        $news_name = get_option('serpforge_news_name', get_bloginfo('name'));
        $selected_types = get_option('serpforge_news_post_types', ['post']);
        
        // Get all public post types
        $post_types = get_post_types(['public' => true], 'objects');
        unset($post_types['attachment']); // Exclude media
        ?>
        <div class="wrap">
            <h1>News Sitemap Settings</h1>
            <p>Configure your Google News Sitemap.</p>
            
            <form method="post" action="">
                <?php wp_nonce_field('serpforge_news_sitemap'); ?>
                <div class="card" style="max-width: 800px; padding: 20px;">
                    <table class="form-table">
                        <tr>
                            <th scope="row">Publication Name</th>
                            <td>
                                <input type="text" name="news_name" value="<?php echo esc_attr($news_name); ?>" class="regular-text">
                                <p class="description">The name of the news publication. It must exactly match the name as it appears on your articles in news.google.com.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Included Post Types</th>
                            <td>
                                <fieldset>
                                    <?php foreach ($post_types as $pt): ?>
                                        <label style="display: block; margin-bottom: 5px;">
                                            <input type="checkbox" name="news_post_types[]" value="<?php echo esc_attr($pt->name); ?>" <?php checked(in_array($pt->name, $selected_types)); ?>>
                                            <?php echo esc_html($pt->label); ?> (<code><?php echo esc_html($pt->name); ?></code>)
                                        </label>
                                    <?php endforeach; ?>
                                </fieldset>
                                <p class="description">Select content types to include in the news sitemap (last 48h only).</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Sitemap URL</th>
                            <td>
                                <a href="<?php echo home_url('/news-sitemap.xml'); ?>" target="_blank" class="button button-secondary">View News Sitemap</a>
                            </td>
                        </tr>
                    </table>
                </div>
                <p><input type="submit" name="save_news_sitemap" class="button button-primary" value="Save Changes"></p>
            </form>
        </div>
        <?php
    }

    public function render_podcast_settings()
    {
        if (isset($_POST['save_podcast_settings']) && check_admin_referer('serpforge_podcast_settings')) {
            update_option('serpforge_podcast_title', sanitize_text_field($_POST['podcast_title']));
            update_option('serpforge_podcast_author', sanitize_text_field($_POST['podcast_author']));
            update_option('serpforge_podcast_email', sanitize_email($_POST['podcast_email']));
            update_option('serpforge_podcast_image', sanitize_url($_POST['podcast_image']));
            update_option('serpforge_podcast_explicit', sanitize_text_field($_POST['podcast_explicit']));
            echo '<div class="notice notice-success is-dismissible"><p>Podcast settings saved.</p></div>';
        }

        $title = get_option('serpforge_podcast_title', get_bloginfo('name'));
        $author = get_option('serpforge_podcast_author', get_bloginfo('name'));
        $email = get_option('serpforge_podcast_email', get_option('admin_email'));
        $image = get_option('serpforge_podcast_image', get_site_icon_url());
        $explicit = get_option('serpforge_podcast_explicit', 'no');
        ?>
        <div class="wrap">
            <h1>Podcast Settings</h1>
            <p>RSS Feed enhancements for Podcasters (iTunes/Apple Podcasts).</p>

            <form method="post" action="">
                <?php wp_nonce_field('serpforge_podcast_settings'); ?>
                <div class="card" style="max-width: 800px; padding: 20px;">
                    <table class="form-table">
                        <tr>
                            <th scope="row">Podcast Title</th>
                            <td>
                                <input type="text" name="podcast_title" value="<?php echo esc_attr($title); ?>" class="regular-text">
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Author Name</th>
                            <td>
                                <input type="text" name="podcast_author" value="<?php echo esc_attr($author); ?>" class="regular-text">
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Owner Email</th>
                            <td>
                                <input type="email" name="podcast_email" value="<?php echo esc_attr($email); ?>" class="regular-text">
                                <p class="description">Email for Apple Podcasts verification.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Cover Art URL</th>
                            <td>
                                <input type="text" name="podcast_image" value="<?php echo esc_url($image); ?>" class="large-text">
                                <p class="description">URL to the cover image (min 1400x1400, max 3000x3000, jpg/png).</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Explicit Content?</th>
                            <td>
                                <select name="podcast_explicit">
                                    <option value="no" <?php selected($explicit, 'no'); ?>>Clean (No)</option>
                                    <option value="yes" <?php selected($explicit, 'yes'); ?>>Explicit (Yes)</option>
                                </select>
                            </td>
                        </tr>
                    </table>
                </div>
                <p><input type="submit" name="save_podcast_settings" class="button button-primary" value="Save Podcast Settings"></p>
            </form>
        </div>
        <?php
    }
    
    public function render_redirects_page()
    {
        // Handle Form Submission
        if (isset($_POST['add_redirect']) && check_admin_referer('serpforge_add_redirect')) {
            $source = sanitize_text_field($_POST['source']);
            $target = sanitize_text_field($_POST['target']);
            $code = intval($_POST['code']);

            $redirects = get_option('serpforge_redirects', []);
            // Use Source URI as key
            $redirects[$source] = ['url' => $target, 'code' => $code];
            update_option('serpforge_redirects', $redirects);
            echo '<div class="notice notice-success is-dismissible"><p>Redirect added.</p></div>';
        }

        // Handle Delete
        if (isset($_GET['delete']) && check_admin_referer('delete_redirect')) {
            $source_del = base64_decode($_GET['delete']);
            $redirects_del = get_option('serpforge_redirects', []);
            if (isset($redirects_del[$source_del])) {
                unset($redirects_del[$source_del]);
                update_option('serpforge_redirects', $redirects_del);
                echo '<div class="notice notice-success is-dismissible"><p>Redirect deleted.</p></div>';
            }
        }

        $redirects = get_option('serpforge_redirects', []);
        ?>
        <div class="wrap">
            <h1>Redirections Manager</h1>

            <div class="card" style="max-width: 600px; padding: 20px; margin-bottom: 20px;">
                <h3>Add New Redirect</h3>
                <form method="post">
                    <?php wp_nonce_field('serpforge_add_redirect'); ?>
                    <p>
                        <label>Source URL (Relative):</label><br>
                        <input type="text" name="source" placeholder="/old-url" class="regular-text" required>
                    </p>
                    <p>
                        <label>Target URL (Absolute or Relative):</label><br>
                        <input type="text" name="target" placeholder="/new-url" class="regular-text" required>
                    </p>
                    <p>
                        <label>Redirection Type:</label><br>
                        <select name="code">
                            <option value="301">301 Permanent Move</option>
                            <option value="302">302 Temporary Move</option>
                            <option value="410">410 Content Deleted</option>
                        </select>
                    </p>
                    <p>
                        <input type="submit" name="add_redirect" value="Add Redirect" class="button button-primary">
                    </p>
                </form>
            </div>

            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th>Source</th>
                        <th>Target</th>
                        <th>Type</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($redirects)): ?>
                        <tr>
                            <td colspan="4">No redirects found.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($redirects as $source => $data): ?>
                            <tr>
                                <td><code><?php echo esc_html($source); ?></code></td>
                                <td><code><?php echo esc_html($data['url']); ?></code></td>
                                <td>
                                    <?php echo esc_html($data['code']); ?>
                                </td>
                                <td>
                                    <?php 
                                    $del_url = add_query_arg([
                                        'page' => 'serpforge-redirects',
                                        'delete' => base64_encode($source)
                                    ], admin_url('admin.php'));
                                    $del_url_nonce = wp_nonce_url($del_url, 'delete_redirect');
                                    ?>
                                    <a href="<?php echo esc_url($del_url_nonce); ?>"
                                        class="button button-small" onclick="return confirm('Delete?');">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php
    }

    /**
     * AJAX: Save Bulk Meta
     */
    public function save_bulk_meta()
    {
        check_ajax_referer('serpforge_admin_nonce', 'nonce');

        $post_id = intval($_POST['post_id']);
        $meta_key = sanitize_text_field($_POST['meta_key']);
        $value = sanitize_text_field($_POST['value']);

        // Whitelist keys
        $allowed_keys = ['_serpforge_seo_title', '_serpforge_seo_description'];
        if (!in_array($meta_key, $allowed_keys)) {
            wp_send_json_error('Invalid Key');
        }

        if (update_post_meta($post_id, $meta_key, $value)) {
            wp_send_json_success();
        } else {
            // It returns false if value is same, so we successfully checked it but didn't need to update.
            // Or it failed. We'll assume success if it didn't crash.
            wp_send_json_success('Updated (or unchanged)');
        }
    }

    public function render_bulk_editor()
    {
        // Pagination
        $paged = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
        $args = [
            'post_type' => ['post', 'page'],
            'post_status' => 'publish',
            'posts_per_page' => 20,
            'paged' => $paged
        ];
        $posts = new \WP_Query($args);
        ?>
        <div class="wrap">
            <h1>Bulk Meta Editor</h1>
            <p>Quickly edit SEO Titles and Meta Descriptions for all your posts.</p>

            <div class="card" style="padding: 0;">
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th style="width: 20%;">Post Title</th>
                            <th style="width: 40%;">SEO Title</th>
                            <th style="width: 40%;">Meta Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!$posts->have_posts()): ?>
                            <tr><td colspan="3">No posts found.</td></tr>
                        <?php else: ?>
                            <?php while ($posts->have_posts()): $posts->the_post(); 
                                $id = get_the_ID();
                                $seo_title = get_post_meta($id, '_serpforge_seo_title', true);
                                $seo_desc = get_post_meta($id, '_serpforge_seo_description', true);
                            ?>
                            <tr>
                                <td>
                                    <strong><?php the_title(); ?></strong><br>
                                    <a href="<?php echo get_edit_post_link($id); ?>" target="_blank">Edit</a> | 
                                    <a href="<?php the_permalink(); ?>" target="_blank">View</a>
                                </td>
                                <td>
                                    <input type="text" class="widefat sf-bulk-input" 
                                           data-id="<?php echo $id; ?>" 
                                           data-key="_serpforge_seo_title" 
                                           value="<?php echo esc_attr($seo_title); ?>"
                                           placeholder="<?php echo esc_attr(get_the_title()); ?>">
                                    <span class="sf-status" id="status-title-<?php echo $id; ?>"></span>
                                </td>
                                <td>
                                    <textarea class="widefat sf-bulk-input" 
                                              rows="2"
                                              data-id="<?php echo $id; ?>" 
                                              data-key="_serpforge_seo_description"><?php echo esc_textarea($seo_desc); ?></textarea>
                                    <span class="sf-status" id="status-desc-<?php echo $id; ?>"></span>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        <?php endif; wp_reset_postdata(); ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination logic simple -->
            <div class="tablenav bottom">
                <div class="tablenav-pages">
                    <?php 
                    echo paginate_links([
                        'base' => add_query_arg('paged', '%#%'),
                        'format' => '',
                        'prev_text' => __('&laquo;'),
                        'next_text' => __('&raquo;'),
                        'total' => $posts->max_num_pages,
                        'current' => $paged
                    ]);
                    ?>
                </div>
            </div>
            
            <style>
                .sf-bulk-input:focus { border-color: #2271b1; box-shadow: 0 0 0 1px #2271b1; }
                .sf-status { font-size: 10px; color: green; margin-top: 5px; display: block; opacity: 0; transition: opacity 0.5s; }
            </style>

            <script type="text/javascript">
            jQuery(document).ready(function($) {
                var timer;
                $('.sf-bulk-input').on('keyup change', function() {
                    var input = $(this);
                    var id = input.data('id');
                    var key = input.data('key');
                    var val = input.val();
                    var statusId = (key === '_serpforge_seo_title') ? '#status-title-' + id : '#status-desc-' + id;
                    
                    clearTimeout(timer);
                    timer = setTimeout(function() {
                        $(statusId).text('Saving...').css({opacity: 1, color: '#999'});
                        
                        $.post(serpforgeData.ajaxUrl, {
                            action: 'serpforge_save_bulk_meta',
                            nonce: serpforgeData.nonce,
                            post_id: id,
                            meta_key: key,
                            value: val
                        }, function(res) {
                            if(res.success) {
                                $(statusId).text('Saved').css({color: 'green'});
                                setTimeout(function(){ $(statusId).css('opacity', 0); }, 2000);
                            } else {
                                $(statusId).text('Error').css({color: 'red'});
                            }
                        });
                    }, 1000); // 1s debounce
                });
            });
            </script>
        </div>
        <?php
    }
}
