<?php
namespace SerpForge\Admin;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Handles General Settings Pages.
 */
class SettingsController
{
    public function render_general_settings()
    {
        if (isset($_POST['save_general_settings']) && check_admin_referer('serpforge_save_general')) {
            update_option('serpforge_google_verify', sanitize_text_field($_POST['google_verify']));
            update_option('serpforge_bing_verify', sanitize_text_field($_POST['bing_verify']));
            update_option('serpforge_separator', sanitize_text_field($_POST['separator']));
            echo '<div class="notice notice-success is-dismissible"><p>Settings saved.</p></div>';
        }

        $google = get_option('serpforge_google_verify', '');
        $bing = get_option('serpforge_bing_verify', '');
        $sep = get_option('serpforge_separator', '-');
        ?>
        <div class="wrap">
            <h1>General Settings</h1>
            <form method="post" action="">
                <?php wp_nonce_field('serpforge_save_general'); ?>

                <div class="card" style="max-width: 800px; padding: 20px; margin-bottom: 20px;">
                    <h2>Webmaster Tools</h2>
                    <table class="form-table">
                        <tr>
                            <th scope="row">Google Search Console</th>
                            <td><input type="text" name="google_verify" value="<?php echo esc_attr($google); ?>"
                                    class="regular-text" placeholder="Verification Code"></td>
                        </tr>
                        <tr>
                            <th scope="row">Bing Webmaster Tools</th>
                            <td><input type="text" name="bing_verify" value="<?php echo esc_attr($bing); ?>"
                                    class="regular-text" placeholder="Verification Code"></td>
                        </tr>
                    </table>
                </div>

                <div class="card" style="max-width: 800px; padding: 20px; margin-bottom: 20px;">
                    <h2>Title Separator</h2>
                    <p>Select the character to use as a separator between your titles and site name.</p>
                    <?php
                    $separators = ['-', '–', '|', '•', '»', '➜'];
                    foreach ($separators as $s) {
                        echo '<label style="margin-right: 15px; font-size: 16px;">';
                        echo '<input type="radio" name="separator" value="' . esc_attr($s) . '" ' . checked($sep, $s, false) . '> ' . esc_html($s);
                        echo '</label>';
                    }
                    ?>
                </div>

                <hr>
                <input type="submit" name="save_general_settings" class="button button-primary button-hero"
                    value="Save Changes">
            </form>
        </div>
        <?php
    }

    public function render_titles_meta()
    {
        if (isset($_POST['save_titles_meta']) && check_admin_referer('serpforge_save_titles')) {
            update_option('serpforge_home_title', sanitize_text_field($_POST['home_title']));
            update_option('serpforge_home_desc', sanitize_textarea_field($_POST['home_desc']));
            update_option('serpforge_post_title_default', sanitize_text_field($_POST['post_title_default']));
            update_option('serpforge_page_title_default', sanitize_text_field($_POST['page_title_default']));
            echo '<div class="notice notice-success is-dismissible"><p>Meta settings saved.</p></div>';
        }

        $home_title = get_option('serpforge_home_title', '%sitename% | %sitedesc%');
        $home_desc = get_option('serpforge_home_desc', '');
        $post_default = get_option('serpforge_post_title_default', '%title% %sep% %sitename%');
        $page_default = get_option('serpforge_page_title_default', '%title% %sep% %sitename%');
        ?>
        <div class="wrap">
            <h1>Titles & Meta</h1>
            <form method="post" action="">
                <?php wp_nonce_field('serpforge_save_titles'); ?>

                <div class="card" style="max-width: 800px; padding: 20px; margin-bottom: 20px;">
                    <h2>Homepage</h2>
                    <p>Configure the title and meta description for your homepage.</p>
                    <table class="form-table">
                        <tr>
                            <th scope="row">Homepage Title</th>
                            <td>
                                <input type="text" name="home_title" value="<?php echo esc_attr($home_title); ?>"
                                    class="large-text">
                                <p class="description">Variables: %sitename%, %sitedesc%</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Homepage Description</th>
                            <td>
                                <textarea name="home_desc" rows="3"
                                    class="large-text"><?php echo esc_textarea($home_desc); ?></textarea>
                            </td>
                        </tr>
                    </table>
                </div>

                <div class="card" style="max-width: 800px; padding: 20px; margin-bottom: 20px;">
                    <h2>Post Types</h2>
                    <table class="form-table">
                        <tr>
                            <th scope="row">Posts Single Title</th>
                            <td>
                                <input type="text" name="post_title_default" value="<?php echo esc_attr($post_default); ?>"
                                    class="large-text">
                                <p class="description">Variables: %title%, %sep%, %sitename%</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Pages Single Title</th>
                            <td>
                                <input type="text" name="page_title_default" value="<?php echo esc_attr($page_default); ?>"
                                    class="large-text">
                            </td>
                        </tr>
                    </table>
                </div>

                <input type="submit" name="save_titles_meta" class="button button-primary button-hero" value="Save Changes">
            </form>
        </div>
        <?php
    }

    public function render_image_seo_settings()
    {
        if (isset($_POST['save_image_seo']) && check_admin_referer('serpforge_image_seo')) {
            update_option('serpforge_auto_alt', isset($_POST['auto_alt']) ? '1' : '0');
            update_option('serpforge_auto_title', isset($_POST['auto_title']) ? '1' : '0');
            echo '<div class="notice notice-success is-dismissible"><p>Image SEO settings saved.</p></div>';
        }

        $auto_alt = get_option('serpforge_auto_alt', '1');
        $auto_title = get_option('serpforge_auto_title', '1');
        ?>
        <div class="wrap">
            <h1>Image SEO Settings</h1>
            <form method="post" action="">
                <?php wp_nonce_field('serpforge_image_seo'); ?>
                <div class="card" style="max-width: 600px; padding: 20px;">
                    <p>
                        <label>
                            <input type="checkbox" name="auto_alt" value="1" <?php checked($auto_alt, '1'); ?>>
                            Add missing ALT attributes automatically
                        </label>
                    </p>
                    <p class="description">Automatically uses the filename to create ALT text if it's missing.</p>
                    <hr>
                    <p>
                        <label>
                            <input type="checkbox" name="auto_title" value="1" <?php checked($auto_title, '1'); ?>>
                            Add missing Title attributes automatically
                        </label>
                    </p>
                    <p class="description">Automatically adds title attributes to image tags.</p>
                    <p><input type="submit" name="save_image_seo" class="button button-primary" value="Save Changes"></p>
                </div>
            </form>
        </div>
        <?php
    }

    public function render_sitemap_settings()
    {
        // Flush Action
        if (isset($_POST['flush_permalinks']) && check_admin_referer('serpforge_sitemap_settings')) {
            flush_rewrite_rules();
            echo '<div class="notice notice-success is-dismissible"><p>Permalinks flushed successfully.</p></div>';
        }

        // Save Logic
        if (isset($_POST['save_sitemap_settings']) && check_admin_referer('serpforge_sitemap_settings')) {
            // inclusions
            $post_types = get_post_types(['public' => true], 'names');
            foreach ($post_types as $pt) {
                $val = isset($_POST["sitemap_include_$pt"]) ? '1' : '0';
                update_option("serpforge_sitemap_include_$pt", $val);
            }
            // exclusions
            update_option('serpforge_sitemap_exclude_ids', sanitize_text_field($_POST['exclude_ids']));

            // Flush rules because we might change sitemaps (if we change logic later)
            flush_rewrite_rules();

            echo '<div class="notice notice-success is-dismissible"><p>Sitemap settings saved.</p></div>';
        }

        $post_types = get_post_types(['public' => true], 'objects');
        $exclude_ids = get_option('serpforge_sitemap_exclude_ids', '');
        ?>
        <div class="wrap">
            <h1>XML Sitemap Settings</h1>
            <p>Configure what content is included in your XML Sitemap.</p>

            <div class="card" style="max-width: 800px; padding: 20px; margin-bottom: 20px;">
                <h3>Sitemap Index</h3>
                <p>Your sitemap is available at:</p>
                <a href="<?php echo home_url('/sitemap_index.xml'); ?>" target="_blank" class="button button-primary">View
                    Sitemap Index</a>

                <hr>

                <h4>Troubleshooting</h4>
                <p>If you see a 404 error, try flushing the permalinks.</p>
                <input type="submit" name="flush_permalinks" class="button button-secondary" value="Flush Permalinks">

                <br><br>
                <details>
                    <summary>Debug: Rewrite Rules Status</summary>
                    <div style="background: #f0f0f1; padding: 10px; margin-top: 10px; border: 1px solid #ccc;">
                        <?php
                        global $wp_rewrite;
                        $rules = $wp_rewrite->wp_rewrite_rules();
                        $found = false;
                        echo '<ul>';
                        foreach ($rules as $key => $val) {
                            if (strpos($key, 'sitemap') !== false || strpos($val, 'serpforge') !== false) {
                                echo "<li><strong>$key</strong> -> $val</li>";
                                $found = true;
                            }
                        }
                        echo '</ul>';
                        if (!$found)
                            echo '<strong>No sitemap rules found!</strong>';
                        ?>
                    </div>
                </details>
            </div>

            <form method="post" action="">
                <?php wp_nonce_field('serpforge_sitemap_settings'); ?>

                <div class="card" style="max-width: 800px; padding: 20px; margin-bottom: 20px;">
                    <h2>Content Types</h2>
                    <p>Select the post types to include in the sitemap.</p>
                    <table class="form-table">
                        <?php foreach ($post_types as $pt):
                            if ($pt->name === 'attachment')
                                continue;
                            $opt_key = "serpforge_sitemap_include_{$pt->name}";
                            // Default true for post and page
                            $default = in_array($pt->name, ['post', 'page']) ? '1' : '0';
                            $checked = get_option($opt_key, $default);
                            ?>
                            <tr>
                                <th scope="row"><?php echo esc_html($pt->label); ?> (<?php echo esc_html($pt->name); ?>)</th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="sitemap_include_<?php echo esc_attr($pt->name); ?>" value="1"
                                            <?php checked($checked, '1'); ?>>
                                        Include in Sitemap
                                    </label>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </div>

                <div class="card" style="max-width: 800px; padding: 20px; margin-bottom: 20px;">
                    <h2>Exclusions</h2>
                    <p>Exclude specific posts or pages from the sitemap.</p>
                    <table class="form-table">
                        <tr>
                            <th scope="row">Exclude Post IDs</th>
                            <td>
                                <input type="text" name="exclude_ids" value="<?php echo esc_attr($exclude_ids); ?>"
                                    class="large-text" placeholder="e.g. 10, 24, 150">
                                <p class="description">Comma-separated list of IDs to remove.</p>
                            </td>
                        </tr>
                    </table>
                </div>

                <p><input type="submit" name="save_sitemap_settings" class="button button-primary"
                        value="Save Sitemap Settings"></p>
            </form>
        </div>
        <?php
    }
}
