<?php
/**
 * Autoloader for SERPforge classes.
 *
 * @package SerpForge\Core
 */

if (!defined('ABSPATH')) {
    exit;
}

spl_autoload_register(function ($class) {
    // Project-specific namespace prefix.
    $prefix = 'SerpForge\\';

    // Base directory for the namespace prefix.
    $base_dir = SERPFORGE_PATH . 'includes/';

    // Does the class use the namespace prefix?
    $len = strlen($prefix);
    if (0 !== strncmp($prefix, $class, $len)) {
        // no, move to the next registered autoloader
        return;
    }

    // Get the relative class name.
    $relative_class = substr($class, $len);

    // Replace the namespace prefix with the base directory, replace namespace
    // separators with directory separators in the relative class name, append
    // with .php
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    // If the file exists, require it.
    if (file_exists($file)) {
        require $file;
    }
});
