<?php
/**
 * Plugin Name: SERPforge SEO
 * Plugin URI:  https://serpforge.compalgolabs.com
 * Description: A professional, all-in-one SEO optimization plugin to help you build pages Google loves.
 * Version:     1.0.1
 * Author:      SERPforge Team
 * License:     GPL-2.0+
 * Text Domain: serpforge-seo
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Define Plugin Constants
define('SERPFORGE_VERSION', '1.0.1'); // Bump version to clear cache
define('SERPFORGE_FILE', __FILE__);
define('SERPFORGE_PATH', plugin_dir_path(__FILE__));
define('SERPFORGE_URL', plugin_dir_url(__FILE__));
define('SERPFORGE_BASENAME', plugin_basename(__FILE__));

// Include Autoloader
require_once SERPFORGE_PATH . 'includes/Core/Autoloader.php';

/**
 * Main instance of SERPforge Plugin.
 *
 * Returns the main instance of SERPforge to prevent the need to use globals.
 *
 * @since  1.0.0
 * @return \SerpForge\Core\Plugin
 */
function serpforge()
{
    return \SerpForge\Core\Plugin::instance();
}

// Global for backward compatibility.
$GLOBALS['serpforge'] = serpforge();
