<?php
/**
 * WordPress Stubs for Static Analysis.
 * This file helps IDEs and Linters understand WP functions when not in a full WP environment.
 */

if (!defined('ABSPATH')) {
    define('ABSPATH', __DIR__ . '/');
}

// Core Functions
function add_action($hook, $callback, $priority = 10, $accepted_args = 1)
{
}
function add_filter($hook, $callback, $priority = 10, $accepted_args = 1)
{
}
function remove_action($hook, $callback, $priority = 10)
{
}
function do_action($hook, ...$arg)
{
}
function apply_filters($hook, $value, ...$args)
{
    return $value;
}
function wp_enqueue_style($handle, $src = '', $deps = [], $ver = false, $media = 'all')
{
}
function wp_enqueue_script($handle, $src = '', $deps = [], $ver = false, $in_footer = false)
{
}
function wp_localize_script($handle, $object_name, $l10n)
{
}
function wp_create_nonce($action = -1)
{
    return 'nonce';
}
function wp_verify_nonce($nonce, $action = -1)
{
    return true;
}
function check_admin_referer($action = -1, $query_arg = '_wpnonce')
{
}
function check_ajax_referer($action = -1, $query_arg = false, $die = true)
{
}
function is_admin()
{
    return true;
}
function is_front_page()
{
    return false;
}
function is_page($page = '')
{
    return false;
}
function is_singular($post_types = '')
{
    return false;
}
function home_url($path = '', $scheme = null)
{
    return 'https://example.com';
}
function site_url($path = '', $scheme = null)
{
    return 'https://example.com';
}
function admin_url($path = '', $scheme = 'admin')
{
    return 'https://example.com/wp-admin/';
}
function get_option($option, $default = false)
{
    return $default;
}
function update_option($option, $value, $autoload = null)
{
    return true;
}
function get_post_meta($post_id, $key = '', $single = false)
{
    return '';
}
function update_post_meta($post_id, $meta_key, $meta_value, $prev_value = '')
{
    return true;
}
function delete_post_meta($post_id, $meta_key, $meta_value = '')
{
    return true;
}
function get_bloginfo($show = '', $filter = 'raw')
{
    return 'Site Name';
}
function get_site_icon_url($size = 512, $url = '', $blog_id = 0)
{
    return '';
}
function esc_html($text)
{
    return $text;
}
function esc_attr($text)
{
    return $text;
}
function esc_url($url, $protocols = null, $_context = 'display')
{
    return $url;
}
function esc_textarea($text)
{
    return $text;
}
function sanitize_text_field($str)
{
    return $str;
}
function sanitize_textarea_field($str)
{
    return $str;
}
function sanitize_url($url, $protocols = null)
{
    return $url;
}
function wp_send_json_success($data = null, $status_code = null)
{
}
function wp_send_json_error($data = null, $status_code = null)
{
}
function wp_redirect($location, $status = 302)
{
}
function add_menu_page($page_title, $menu_title, $capability, $menu_slug, $function = '', $icon_url = '', $position = null)
{
}
function add_submenu_page($parent_slug, $page_title, $menu_title, $capability, $menu_slug, $function = '')
{
}
function add_meta_box($id, $title, $callback, $screen = null, $context = 'advanced', $priority = 'default', $callback_args = null)
{
}
function __($text, $domain = 'default')
{
    return $text;
}
function _e($text, $domain = 'default')
{
    echo $text;
}
function esc_html__($text, $domain = 'default')
{
    return $text;
}
function esc_html_e($text, $domain = 'default')
{
    echo $text;
}
function checked($checked, $current = true, $echo = true)
{
    return ' checked="checked"';
}
function selected($selected, $current = true, $echo = true)
{
    return ' selected="selected"';
}
function current_user_can($capability, ...$args)
{
    return true;
}
function get_the_title($post = 0)
{
    return 'Title';
}
function get_the_excerpt($post = 0)
{
    return 'Excerpt';
}
function get_permalink($post = 0, $leavename = false)
{
    return 'https://example.com/post';
}
function get_posts($args = null)
{
    return [];
}
function wp_json_encode($data, $options = 0, $depth = 512)
{
    return json_encode($data);
}

function get_edit_post_link($id = 0, $context = 'display')
{
    return 'https://example.com/wp-admin/post.php?post=1&action=edit';
}
function wp_nonce_url($actionurl, $action = -1, $name = '_wpnonce')
{
    return $actionurl;
}
function wp_is_post_revision($post)
{
    return false;
}
function get_post_types($args = [], $output = 'names', $operator = 'and')
{
    if ($output == 'objects') {
        $pt = new stdClass();
        $pt->name = 'post';
        $pt->label = 'Posts';
        $pt->public = true;
        return [$pt];
    }
    return ['post', 'page'];
}
function get_post_type_object($post_type)
{
    if ($post_type) {
        $pt = new stdClass();
        $pt->name = $post_type;
        $pt->label = ucfirst($post_type);
        $pt->public = true;
        return $pt;
    }
    return null;
}
function flush_rewrite_rules($hard = true)
{
}
function get_the_modified_date($format = '', $post = null)
{
    return date('c');
}
function add_rewrite_rule($regex, $query, $after = 'bottom')
{
}
function get_query_var($var, $default = '')
{
    return $default;
}
function status_header($code, $description = '')
{
}
function get_locale()
{
    return 'en_US';
}
function is_single($post = '')
{
    return false;
}

// Classes
class WP_Post
{
    public $ID;
    public $post_title;
    public $post_content;
    public $post_type;
}

class WP_Query
{
    public $posts = [];
    public function __construct($args = [])
    {
        $this->posts = [1, 2, 3];
    }
}

const DOING_AUTOSAVE = false;
